#include "modelManager.h"
#include "renderer.h"

// ======== ======== ======== ======== ======== ======== ======== ========
// 
// -------- -------- -------- -------- -------- -------- -------- --------
void CModelManager::Init(void)
{
	m_umapModel.clear();
}

// ======== ======== ======== ======== ======== ======== ======== ========
// I
// -------- -------- -------- -------- -------- -------- -------- --------
void CModelManager::Uninit(void)
{
	ReleaseAll();
}

// ======== ======== ======== ======== ======== ======== ======== ========
// fݒ
// -------- -------- -------- -------- -------- -------- -------- --------
bool CModelManager::SetModel(const std::string &strFilePass)
{
	// null`FbN
	if(strFilePass.empty()){return false;}

	// ̃pXɂ邩`FbN
	if (m_umapModel.count(strFilePass) >= 1) { return true; }

	// foCX̎擾
	LPDIRECT3DDEVICE9 pDevice = CRenderer::GetDevice();

	// fCX^X̐
	MODEL *pModel = new MODEL;

	// fǂݍ
	if(FAILED(D3DXLoadMeshFromX(&strFilePass[0], D3DXMESH_MANAGED, pDevice, nullptr, &pModel->pBuffMat, nullptr, &pModel->numMat, &pModel->pMesh)))
	{
		assert(!"f̓ǂݍ݂Ɏs܂");
		return false;
	}

	// Xt@Cɖ@Ȃꍇ́A@
	if (!(pModel->pMesh->GetFVF() & D3DFVF_NORMAL)) {

		ID3DXMesh* pTempMesh = nullptr;

		pModel->pMesh->CloneMeshFVF(pModel->pMesh->GetOptions(),
			pModel->pMesh->GetFVF() | D3DFVF_NORMAL, pDevice, &pTempMesh);

		D3DXComputeNormals(pTempMesh, nullptr);
		pModel->pMesh->Release();
		pModel->pMesh = pTempMesh;
	}

	// }eÃ|C^Ƃăobt@̃AhX擾
	pModel->pMat = (D3DXMATERIAL*)pModel->pBuffMat->GetBufferPointer();

	m_umapModel[strFilePass] = pModel;

	return true;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// bVC^[tFCX擾
// -------- -------- -------- -------- -------- -------- -------- --------
LPD3DXMESH CModelManager::GetModelMesh(const std::string &strFilePass)
{
	// null`FbN
	if(strFilePass.empty()){return nullptr;}

	// ̃pXɂ邩`FbN
	if (m_umapModel.count(strFilePass) >= 1)
	{ 
		return m_umapModel[strFilePass]->pMesh;
	}

	// ̃bVC^[tFCX͖ł
	return nullptr;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// }eA擾
// -------- -------- -------- -------- -------- -------- -------- --------
LPD3DXBUFFER CModelManager::GetModelBuffMat(const std::string &strFilePass)
{
	// null`FbN
	if (strFilePass.empty()) { return nullptr; }

	// ̃pXɂ邩`FbN
	if (m_umapModel.count(strFilePass) >= 1)
	{
		return m_umapModel[strFilePass]->pBuffMat;
	}

	// ̃}eA͖ł
	return nullptr;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// }eA擾
// -------- -------- -------- -------- -------- -------- -------- --------
DWORD CModelManager::GetModelNumMat(const std::string &strFilePass)
{
	// null`FbN
	if (strFilePass.empty()) { return (DWORD)-1; }

	// ̃pXɂ邩`FbN
	if (m_umapModel.count(strFilePass) >= 1)
	{
		return m_umapModel[strFilePass]->numMat;
	}

	// }eA͖ݒł
	return (DWORD)-1;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// }eA擾
// -------- -------- -------- -------- -------- -------- -------- --------
D3DXMATERIAL *CModelManager::GetModelMat(const std::string &strFilePass)
{
	// null`FbN
	if (strFilePass.empty()) { return nullptr; }

	// ̃pXɂ邩`FbN
	if (m_umapModel.count(strFilePass) >= 1)
	{
		return m_umapModel[strFilePass]->pMat;
	}

	// ̃}eA͖ł
	return nullptr;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// f
// -------- -------- -------- -------- -------- -------- -------- --------
bool CModelManager::Release(const std::string &strFilePass)
{
	// null`FbN
	if (strFilePass.empty()) { return false; }

	// ̃pXɂ邩`FbN
	if (m_umapModel.count(strFilePass) >= 1)
	{
		if (m_umapModel[strFilePass]->pMesh != nullptr)
		{
			m_umapModel[strFilePass]->pMesh->Release();		// bV
			m_umapModel[strFilePass]->pMesh = nullptr;
		}
		if (m_umapModel[strFilePass]->pBuffMat != nullptr)
		{
			m_umapModel[strFilePass]->pBuffMat->Release();	// }eAobt@
			m_umapModel[strFilePass]->pBuffMat = nullptr;
		}
		m_umapModel.erase(strFilePass);
		return true;
	}

	// ł܂ł
	return false;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// fS
// -------- -------- -------- -------- -------- -------- -------- --------
void CModelManager::ReleaseAll(void)
{
	// S
	for (auto it : m_umapModel)
	{
		if (it.second->pMesh != nullptr)
		{
			it.second->pMesh->Release();		// bV
			it.second->pMesh = nullptr;
		}
		if (it.second->pBuffMat != nullptr)
		{
			it.second->pBuffMat->Release();		// }eAobt@
			it.second->pBuffMat = nullptr;
		}
	}
	m_umapModel.clear();
}